﻿using System;
using Curse.Friends.Enums;
using Curse.SocketMessages;

namespace Curse.Friends.NotificationContracts
{
    [ServiceContract(ServiceContractDirection.Notification)]
    public class GroupPresenceNotification : Contract<GroupPresenceNotification>
    {
        public Guid GroupID { get; set; }
        public GroupPresenceContract[] Users { get; set; }
    }

    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupPresenceContract
    {
        public int UserID { get; set; }
        public UserConnectionStatus ConnectionStatus { get; set; }
        public int GameID { get; set; }
        public long DateLastSeen { get; set; }
        public bool IsActive { get; set; }
    }
}
