﻿using System.Security.Authentication;
using Curse.Friends.Enums;
using Curse.SocketMessages;
using ProtoBuf;

namespace Curse.Friends.NotificationContracts
{
    [ProtoContract]
    [ServiceContract]
    public class JoinRequest : Contract<JoinRequest>
    {
        [ProtoMember(1)]
        public int UserID { get; set; }

        [ProtoMember(2)]
        public string MachineKey { get; set; }

        [ProtoMember(3)]
        public string SessionID { get; set; }

        [ProtoMember(4)]
        public UserConnectionStatus Status { get; set; }

        [ProtoMember(5)]
        public string ClientVersion { get; set; }

        [ProtoMember(6)]
        public byte[] PublicKey { get; set; }

        [ProtoMember(7)]
        public CipherAlgorithmType CipherAlgorithm { get; set; }

        [ProtoMember(8)]
        public int CipherStrength { get; set; }        
    }
}
