﻿using System;
using Curse.Friends.Enums;
using Curse.SocketMessages;
using ProtoBuf;

namespace Curse.Friends.NotificationContracts
{
    [ServiceContract]
    public enum JoinStatus
    {
        Successful = 1,
        FailedUnhandledException,
        InvalidClientVersion,
        InvalidSessionID,
        Timeout,
        Throttled
    }

    [ProtoContract]
    [ServiceContract]
    public class JoinResponse : Contract<JoinResponse>
    {
        [ProtoMember(1)]
        public JoinStatus Status { get; set; }

        [ProtoMember(2)]
        public DateTime ServerTime { get; set; }

        [ProtoMember(3)]
        public byte[] EncryptedSessionKey { get; set; }

        [ProtoMember(4)]
        public UserConnectionStatus ConnectionStatus { get; set; }
    }
}
