﻿using System;
using Curse.Friends.Enums;
using Curse.SocketMessages;
using ProtoBuf;

namespace Curse.Friends.NotificationContracts
{
    [ProtoContract]
    [EncryptedContract]
    [Obsolete]
    [ServiceContract(ServiceContractDirection.Notification, "GroupChangeNotification")]
    public class LegacyGroupChangeNotification : Contract<LegacyGroupChangeNotification>
    {
        public LegacyGroupChangeNotification()
        {
            TimeStamp = DateTime.UtcNow;
        }

        /// <summary>
        /// The type of change affecting the group.
        /// </summary>
        [ProtoMember(1)]
        public GroupChangeType ChangeType { get; set; }

        /// <summary>
        /// The ID of the user that caused the change.
        /// </summary>
        [ProtoMember(2)]
        public int SenderID { get; set; }

        /// <summary>
        /// The group that has changed.
        /// </summary>
        [ProtoMember(3)]
        public LegacyGroupNotification Group { get; set; }


        // Used to prevent nulls
        private GroupMemberNotification[] _members = new GroupMemberNotification[0];

        /// <summary>
        /// The members affected by this change.
        /// </summary>
        /// <remarks>
        /// This field is only populated for GroupCreated, UsersAdded, UsersRemoved, and UsersUpdated changes.
        /// 
        /// GroupCreated notifications include the complete member list for Normal and Large Root groups.
        /// 
        /// UsersAdded, UsersRemoved, and UsersUpdated only include the affected members.
        /// </remarks>
        [ProtoMember(4)]
        public GroupMemberNotification[] Members
        {
            get { return _members; }
            set { _members = value; }
        }

        /// <summary>
        /// When this change occurred.
        /// </summary>
        [ProtoMember(5)]
        public DateTime TimeStamp { get; set; }

        // Used to prevent nulls
        private LegacyGroupNotification[] _childGroups = new LegacyGroupNotification[0];

        /// <summary>
        /// This child groups affected by this change.
        /// </summary>
        /// <remarks>
        /// This field is only populated for GroupReorganized changes and only includes changed child groups.
        /// </remarks>
        [ProtoMember(6)]
        public LegacyGroupNotification[] ChildGroups
        {
            get { return _childGroups; }
            set { _childGroups = value; }
        }
    }
}
