﻿using System;
using System.Collections.Generic;
using Curse.Friends.Enums;
using ProtoBuf;

namespace Curse.Friends.NotificationContracts
{
    [ProtoContract]
    [Obsolete]
    public class LegacyGroupNotification
    {
        /// <summary>
        /// This group's title.
        /// </summary>
        [ProtoMember(1)]
        public string GroupTitle
        {
            get;
            set;
        }

        /// <summary>
        /// The URL for this group's avatar/logo.
        /// </summary>
        [ProtoMember(2)]
        public string GroupAvatar
        {
            get;
            set;
        }

        /// <summary>
        /// The ID of this group (Metadata).
        /// </summary>
        [ProtoMember(3)]
        public Guid GroupID
        {
            get;
            set;
        }

        /// <summary>
        /// The ID of this group's parent (Metadata).
        /// </summary>
        [ProtoMember(4)]
        public Guid ParentGroupID
        {
            get;
            set;
        }

        /// <summary>
        /// The ID of this group's root (Metadata).
        /// </summary>
        [ProtoMember(5)]
        public Guid RootGroupID
        {
            get;
            set;
        }

        /// <summary>
        /// This group's voice session code.
        /// </summary>
        [ProtoMember(6)]
        public string VoiceSessionCode
        {
            get;
            set;
        }

        /// <summary>
        /// This group's message of the day.
        /// </summary>
        [ProtoMember(7)]
        public string MessageOfTheDay
        {
            get;
            set;
        }

        /// <summary>
        /// The minimum role needed to access this group.
        /// </summary>
        [ProtoMember(8)]
        public LegacyGroupRole GroupAccessLevel
        {
            get;
            set;
        }

        /// <summary>
        /// This group's type.
        /// </summary>
        [ProtoMember(9)]
        public GroupType GroupType
        {
            get;
            set;
        }

        /// <summary>
        /// The display order of this group (Metadata).
        /// </summary>
        [ProtoMember(10)]
        public int DisplayOrder
        {
            get;
            set;
        }

        /// <summary>
        /// When true, this notification only includes: GroupID, ParentGroupID, RootGroupID and DisplayOrder.
        /// All other fields will be empty.
        /// </summary>
        [ProtoMember(11)]
        public bool MetaDataOnly
        {
            get;
            set;
        }

        /// <summary>
        /// A mapping from an action to the minimum role allowed to perform the action.
        /// </summary>
        [ProtoMember(12)]
        public Dictionary<GroupPermissions, int> GroupPermissions
        {
            get;
            set;
        }

        /// <summary>
        /// A mapping from a group's role to the role's name.
        /// </summary>
        [ProtoMember(13)]
        public Dictionary<LegacyGroupRole, string> GroupRoleNames
        {
            get;
            set;
        }

        /// <summary>
        /// Whether or not this group allows temporary child groups to be created.
        /// </summary>
        [ProtoMember(14)]
        public bool AllowTemporaryChildGroups { get; set; }

        /// <summary>
        /// Whether or not this group required push-to-talk in voice sessions.
        /// </summary>
        [ProtoMember(15)]
        public bool ForcePushToTalk { get; set; }

        [ProtoMember(16)]
        public GroupStatus Status { get; set; }

        [ProtoMember(17)]
        public bool IsDefaultChannel { get; set; }
    }
}
