﻿using Curse.Friends.Enums;
using ProtoBuf;
using System;
using Curse.SocketMessages;

namespace Curse.Friends.NotificationContracts
{
    
    [ServiceContract]
    public class UserContract
    {
        
        public int UserID
        {
            get;
            set;

        }
        
        public string Username
        {
            get;
            set;
        }
        
        public UserConnectionStatus ConnectionStatus
        {
            get;
            set;
        }
        
        public string CustomStatusMessage
        {
            get;
            set;
        }
        
        public DateTime CustomStatusTimestamp
        {
            get;
            set;
        }
        
        public int FriendCount
        {
            get;
            set;

        }
               
        public int CurrentGameID
        {
            get;
            set;
        }
        
        public int CurrentGameState
        {
            get;
            set;
        }
        
        public string CurrentGameStatusMessage
        {
            get;
            set;
        }
        
        public DateTime CurrentGameTimestamp
        {
            get;
            set;
        }
        
        public PushNotificationPreference GroupMessagePushPreference { get; set; }
      
        public PushNotificationPreference FriendMessagePushPreference { get; set; }
        
        public bool FriendRequestPushEnabled { get; set; }
        
        public bool? MentionsPushEnabled { get; set; }
        
        public long AvatarTimestamp { get; set; }
        
        public string DisplayName { get; set; }

        public ExternalCommunityPublicContract WatchingChannel { get; set; }

        public bool IsBroadcasting { get; set; }

        public int BroadcastingGameID { get; set; }

        public UserPrivacySettingsContract PrivacySettings { get; set; }

        public int ConfirmedFriendSyncCount { get; set; }
        public int DeclinedFriendSyncCount { get; set; }
        public bool IsPartner { get; set; }
        public bool HasSeenPartnerUpsell { get; set; }
    }
}
