﻿using System.Linq;
using System.Net;
using System.Net.NetworkInformation;
using System.Net.Sockets;

namespace Curse.Friends.NotificationService
{
    public static class NetworkHelper
    {
        public static string GetInternalIpAddress()
        {            
            var nics = NetworkInterface.GetAllNetworkInterfaces();
            foreach (var nic in nics.Where(p => p.OperationalStatus == OperationalStatus.Up && p.NetworkInterfaceType == NetworkInterfaceType.Ethernet))
            {
                foreach (var ua in nic.GetIPProperties().UnicastAddresses)
                {
                    if (ua.Address.AddressFamily == AddressFamily.InterNetwork)
                    {
                        return ua.Address.ToString();
                    }
                }
            }

            return null;
        }

        public static string GetPublicIpAddress()
        {
#if DEBUG || CONFIG_STAGING || CONFIG_LOADTESTING
            return GetInternalIpAddress();
#else

            using (var client = new WebClient())
            {
                var ipString = client.DownloadString("http://169.254.169.254/latest/meta-data/public-ipv4");
                IPAddress ip;
                if(IPAddress.TryParse(ipString, out ip))
                {
                    return ipString;
                }

                return null;
            }
            
#endif

        }
    }
}
