﻿using System;
using System.Diagnostics;
using System.Reflection;
using System.Web;
using Curse.Friends.Configuration;
using Curse.Friends.NotificationProcessing;
using Curse.Friends.ServiceClients;
using Curse.Friends.Statistics;
using Curse.Logging;
using Curse.Logging.Uploader;

namespace Curse.Friends.NotificationsWebService
{
    public class Global : System.Web.HttpApplication
    {

        protected void Application_Start(object sender, EventArgs e)
        {
            var sw = Stopwatch.StartNew();

            Logger.Init(new LoggerConfig(@"C:\Curse\NotificationWebService", "Logs"));            
            LogUploader.Initialize((int)ServiceHostType.NotificationsService, FriendsServiceConfiguration.Instance.CentralLogServiceUrl, FriendsServiceConfiguration.Instance.LoggingServiceApiKey);
            var version = new Version(0,0,0,1);
            
            try
            {
                version = Assembly.GetExecutingAssembly().GetName().Version;
            }
            catch
            {
                
            }

            Logger.Info("Starting notification service", new { Version = version.ToString() });

            Logger.Info("Determining current region...");
            var currentRegion = StorageConfiguration.GetCurrentRegion();

            if (currentRegion == null)
            {
                Logger.Error("Failed to determine current region!");
            }
            else
            {
                Logger.Info("Current region detected: "  + currentRegion.Key);
            }

            Logger.Info("Initializing friends service client...");
            FriendsServiceClients.Initialize(FriendsServiceConfiguration.Instance.EncryptionKey, FriendsServiceConfiguration.Instance.EncryptionIterations, FriendsServiceConfiguration.Instance.CentralServiceApiKey);

            FriendsStatsManager.Initialize((int)ServiceHostType.NotificationsService, ServiceHostType.NotificationsService.ToString(), currentRegion != null ? currentRegion.ID : 1, null, HostCounter.All);

            FriendsStatsManager.BeginStartup();

            StorageConfiguration.Initialize("FriendsWebService");            
            RequestProcessing.RegisterDispatchers();
            RequestProcessing.Start();
            QueueProcessors.StartQueueProcessors();            
            sw.Stop();            
            Logger.Info("Notification service started in " + sw.Elapsed.TotalSeconds.ToString("F1") + " seconds");
            FriendsStatsManager.Started();
        }
      
        protected void Application_Error(object sender, EventArgs e)
        {
            try
            {
                var error = Server.GetLastError();
                if (error != null && !(error is HttpException))
                {
                    Logger.Error(error, "General service error");
                }
            }
            catch { }
            
        }

        
        protected void Application_End(object sender, EventArgs e)
        {
            RequestProcessing.Stop();          

            try
            {                
                FriendsStatsManager.BeginShutdown();
            }
            catch (Exception ex)
            {
                Logger.Error(ex);
            }

            try
            {
                Logger.Info("Shutting down storage...");
                StorageConfiguration.Shutdown();
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to close all queue connections!");
            }


            try
            {
                Logger.Info("Shutting down stats manager...");
                FriendsStatsManager.Shutdown();
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to shutdown stats manager!");
            }

            try
            {
                LogUploader.Shutdown();
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to finish log upload!");
            }
        }
    }
}