﻿using System;
using System.Threading;
using Curse.Friends.Configuration;
using Curse.Friends.NotificationProcessing;
using Curse.Logging;
using Curse.WebSocketInterface;
using Microsoft.Web.WebSockets;

namespace Curse.Friends.NotificationsWebService
{
    public class NotificationWebSocket : WebSocketHandler
    {
        private BaseWebSocketInterface _socketInterface;
        private static int _clientCounter;

        public override void OnOpen()
        {
            if (NotificationInstance.SessionCount >= FriendsServiceConfiguration.Instance.NotificationServiceMaxConnections || !RequestProcessing.IsStarted)
            {
                Close();
                return;                
            }

            _socketInterface = new BaseWebSocketInterface(this, Interlocked.Increment(ref _clientCounter));
        }
        
        public override void OnMessage(string message)
        {
            try
            {
                var socketInterface = _socketInterface;
                if (socketInterface == null)
                {
                    return;
                }

                socketInterface.ProcessIncomingMessage(message);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to process incoming message!");   
            }                        
        }
        
        public override void OnClose()
        {
            var socketInterface = _socketInterface;

            if (socketInterface == null)
            {
                return;
            }

            Interlocked.Decrement(ref _clientCounter);
            var session = socketInterface.Session;
            if (session != null)
            {
                session.Disconnect();   
            }
        }
    }
}