﻿using System.Linq;
using System.Net;
using System.Web;
using Curse.Friends.Configuration;
using Curse.Friends.NotificationProcessing;
using Curse.Logging;
using Microsoft.Web.WebSockets;

namespace Curse.Friends.NotificationsWebService
{
    /// <summary>
    /// Summary description for NotificationHandler
    /// </summary>
    public class NotificationHandler : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {            
            if (context.IsWebSocketRequest)
            {                
                context.AcceptWebSocketRequest(new NotificationWebSocket());
            }
            else
            {
                if (context.Request.QueryString.AllKeys.Contains("shutdown"))                    
                {
                    if (!IsLocalRequest(context))
                    {
                        Logger.Warn("Attempt to send shutdown command from a non local IP.", new { IPAddress = context.Request.UserHostAddress });
                        context.Response.StatusCode = (int)HttpStatusCode.Forbidden;     
                        return;
                    }

                    if(context.Request.QueryString["apikey"] != FriendsServiceConfiguration.Instance.ServiceShutdownKey)
                    {
                        Logger.Warn("Attempt to send shutdown command with an incorrect API key", new { IPAddress = context.Request.UserHostAddress });
                        context.Response.StatusCode = (int)HttpStatusCode.Forbidden;
                        return;
                    }

                    Logger.Info("Received service shutdown command!", new { IPAddress = context.Request.UserHostAddress });
                    
                    // Server is going to be shutdown!
                    NotificationInstance.BeginShutdown();                    
                    context.Response.Write("Service has been flagged as shutting down!");
                    context.Response.StatusCode = (int)HttpStatusCode.OK;
                    return; 
                }

                context.Response.Write("This server only speaks WebSocketese... But Hello from " + FriendsServiceConfiguration.Instance.LastKnownRegion);
                context.Response.StatusCode = (int)HttpStatusCode.OK;                
            }            
        }

        private bool IsLocalRequest(HttpContext context)
        {
            return context.Request.UserHostAddress.StartsWith("10.") || context.Request.UserHostAddress.StartsWith("192.168.") || context.Request.UserHostAddress == "127.0.0.1";
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}