﻿using System;
using System.Diagnostics;
using System.ServiceProcess;

namespace Curse.Friends.PollService
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        static void Main()
        {
            if (Debugger.IsAttached)
            {
                Console.Write("Starting Poll Service...");

                var service = new PollService();
                service.OnDebugStart();
                Console.WriteLine("Done!");
                Console.WriteLine("Press Enter to stop!");
                Console.ReadLine();

                Console.Write("Shutting down Poll Service...");
                service.OnDebugStop();
                Console.WriteLine("Done!");
            }
            else
            {                
                ServiceBase.Run(new ServiceBase[] { new PollService() });
            }
        }
    }
}
