﻿using Amazon;
using Amazon.KeyManagementService;
using Amazon.Runtime.CredentialManagement;
using Amazon.S3;
using Twitch.Arcana;

namespace Curse.Friends.PreDeployTools
{
    public static class SecretsHelper
    {
        public static CurseSecretsHelper GetSecretsHelper()
        {
            // the deploy tools don't use the app.config because msbuild is the running executable. need to work around the aws profile setup.
            var credsFile = new NetSDKCredentialsFile();
            CredentialProfile profile = null;
            credsFile.TryGetProfile("assume-curse", out profile);
            var creds = profile.GetAWSCredentials(credsFile);
            var s3 = new AmazonS3Client(creds, RegionEndpoint.USEast1);
            var kms = new AmazonKeyManagementServiceClient(creds, RegionEndpoint.USEast1);
            var arcana = new Twitch.Arcana.Arcana(s3, kms, new ArcanaOptions
            {
                DefaultService = "deploy-scripts",
                DefaultBucket = "arcana-for-curse"
            });
            return new CurseSecretsHelper(arcana);
        }
    }
}
