﻿using System.Xml.Serialization;
using Curse.Friends.Configuration;
using Curse.Friends.S3;

namespace Curse.Friends.ReportingWebService.Configuration
{

    [XmlRoot("Service")]
    public class ReportingWebServiceConfiguration
    {
        private static ReportingWebServiceConfiguration _current;
        public static ReportingWebServiceConfiguration Current
        {
            get
            {
                if (_current == null)
                {
                    _current = ConfigurationHelper.LoadConfiguration<ReportingWebServiceConfiguration>(FriendsServiceConfiguration.Mode, "ReportingWebServiceConfiguration");
                }

                return _current;
            }
        }

        [XmlElement]
        public S3BucketConfiguration EventBucket { get; set; }

        [XmlElement("EventDumpConfiguration")]
        public EventDumpConfiguration[] EventDumpConfigs { get; set; }

        [XmlElement]
        public int StatsIntervalMinutes { get; set; }
    }

    public class EventDumpConfiguration
    {
        [XmlElement]
        public string Name { get; set; }

        [XmlElement("IncludeFilter")]
        public string[] IncludeFilters { get; set; }

        [XmlElement("ExcludeFilter")]
        public string[] ExcludeFilters { get; set; }
    }
}