﻿using System.Collections.Generic;
using Curse.Friends.MicroService;

namespace Curse.Friends.ReportingWebService.Contracts
{
    public class EventReportContract : BaseRequestContract
    {
        public long ClientTime { get; set; }
        public string ClientBuild { get; set; }
        public string ClientVersion { get; set; }
        public string Locale { get; set; }
        public string Branch { get; set; }
        public string Device { get; set; }
        public string DeviceID { get; set; }
        public string DeviceModel { get; set; }
        public string DeviceSoftware { get; set; }
        public string EventKey { get; set; }
        public string EventCategory { get; set; }
        public string EventName { get; set; }

        public Dictionary<string,object> AdditionalData { get; set; }

        protected override bool DoValidate()
        {
            if (string.IsNullOrEmpty(EventCategory))
            {
                _validationMessage = "Missing event category";
                return false;
            }

            if (string.IsNullOrEmpty(EventName))
            {
                _validationMessage = "Missing event name";
                return false;
            }

            return true;
        }
    }
}