﻿using Curse.Extensions;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;
using System;

namespace Curse.Friends.ReportingWebService.Contracts
{
    public class UsageProfile : BaseRequestContract
    {                
        public string ClientVersion { get; set; }        
        public string OperatingSystemVersion { get; set; }
        public string OperatingSystemPlatform { get; set; }        
        public int MainWindowHeight { get; set; }
        public int MainWindowWidth { get; set; }                             
        public string ReferralCode { get; set; }
        public bool SoftwareRendering { get; set; }
        public float DotNetVersion { get; set; }    
        public DevicePlatform Platform { get; set; }
        public long LastCallTimestamp { get; set; }

        protected override bool DoValidate()
        {
            if (!OperatingSystemVersion.SafeRange(0, 256))
            {
                _validationMessage = "Invalid OperatingSystemVersion";
                return false;
            }

            if (!OperatingSystemPlatform.SafeRange(0, 256))
            {
                _validationMessage = "Invalid OperatingSystemPlatform";
                return false;
            }

            Version version;
            if(!Version.TryParse(ClientVersion, out version))
            {
                _validationMessage = "Invalid ClientVersion";
                return false;
            }

            // Soft fail
            if (MainWindowHeight < 0 || MainWindowHeight > 10000)
            {
                MainWindowHeight = 0;
            }

            // Soft fail
            if (MainWindowWidth < 0 || MainWindowWidth > 10000)
            {
                MainWindowWidth = 0;
                return false;
            }

            if (!ReferralCode.SafeRange(0, 16))
            {
                _validationMessage = "Invalid ReferralCode";
                return false;
            }

            return true;
        }
    }
}