﻿using System;
using System.Net;
using System.Web.Http;
using System.Web.Http.Description;
using Curse.Friends.MicroService;
using Curse.Friends.ReportingWebService.Contracts;
using Curse.Logging;
using Curse.Friends.Data;
using Curse.Friends.Enums;

namespace Curse.Friends.ReportingWebService.Controllers
{
    [RoutePrefix("reporting")]
    public class ReportingController : MicroServiceController
    {       
        [HttpPost]
        [Route("usage")]
        [ResponseType(typeof(void))]
        public IHttpActionResult Usage(UsageProfile usageProfile)
        {
            return Ok();
        }
       
        [HttpPost]
        [Route("events")]
        [ResponseType(typeof (void))]
        [AuthenticationFilter(AuthenticationLevel.Anonymous)]
        public IHttpActionResult ReportEvent([FromBody] EventReportContract[] data)
        {
            if (data == null || data.Length == 0)
            {
                return BadRequest();
            }

            ReportingStats.BatchCount();            

            foreach (var datum in data)
            {
                try
                {
                    datum.Validate();
                    datum.EventKey = datum.EventKey ?? string.Join("_", "curse", datum.EventCategory, datum.EventName);
                    ReportingStats.BatchItemCount();
                    EventManager.ReportEvent(Token.UserID, GetCurrentIpAddress(), datum);
                }
                catch (Exception ex)
                {
                    Logger.Error(ex, "Report event failed", datum);
                }
            }
            return StatusCode(HttpStatusCode.Accepted);
        }      

        [HttpPost]
        [Route("tracking/{trackingType}")]
        [ResponseType(typeof(void))]
        public IHttpActionResult TrackPartnerUpsell(UserTrackingType trackingType)
        {
            try
            {
                UserTracking.TrackAction(Token.UserID, trackingType);
            }
            catch(Exception ex)
            {
                Logger.Warn(ex, "Failed to track action for user", new { Token.UserID, Token.Username, TrackingType = trackingType.ToString() });
            }

            return StatusCode(HttpStatusCode.Accepted);
        }
    }
}