﻿using System;
using System.Collections.Generic;
using Newtonsoft.Json;

namespace Curse.Friends.ReportingWebService
{
    public class EventReport
    {
        [JsonProperty("event_id")]
        public Guid EventID{get; set; }

        [JsonProperty("event")]
        public string EventKey { get; set; }

        [JsonProperty("timestamp")]
        public long ClientTime { get; set; }

        [JsonProperty("server_timestamp")]
        public long Timestamp { get; set; }

        [JsonProperty("curse_user_id")]
        public int UserID { get; set; }

        [JsonProperty("curse_login")]
        public string Username { get; set; }

        [JsonProperty("user_id")]
        public long TwitchUserID { get;set; }

        [JsonProperty("login")]
        public string TwitchUsername { get; set; }

        [JsonProperty("client_ip")]
        public string IPAddress { get; set; }

        [JsonProperty("locale")]
        public string Locale { get; set; }

        [JsonProperty("branch")]
        public string Branch { get; set; }

        [JsonProperty("app_build")]
        public string ClientBuild { get; set; }

        [JsonProperty("app_version")]
        public string ClientVersion { get; set; }

        [JsonProperty("platform")]
        public string Device { get; set; }

        [JsonProperty("device_id")]
        public string DeviceID { get; set; }

        [JsonProperty("device_model")]
        public string DeviceModel { get; set; }

        [JsonProperty("device_software")]
        public string DeviceSoftware { get; set; }

        [JsonProperty("event_category")]
        public string EventCategory { get; set; }

        [JsonProperty("event_name")]
        public string EventName { get; set; }


        [JsonProperty("additional_data")]
        public IDictionary<string, object> AdditionalData { get; set; }
    }
}