﻿using System;
using System.Threading.Tasks;
using Curse.Friends.Configuration;
using Curse.Friends.MicroService;
using Curse.Friends.ReportingWebService.Configuration;
using Curse.Logging;

namespace Curse.Friends.ReportingWebService
{
    public class WebApiApplication : MicroServiceApplication
    {
        protected override ServiceHostType ServiceType
        {
            get { return ServiceHostType.ReportingWebService; }
        }

        protected override string ServiceDescription
        {
            get { return "Provides functionality for client usage reporting."; }
        }

        protected override ConfigurationServices ConfigurationServices
        {
            get { return ConfigurationServices.Database; }
        }

        protected override void CustomApplicationStartup()
        {
            EventManager.Start();
            ReportingStats.Start();
        }



        protected override void CustomApplicationShutdown()
        {
            EventManager.Stop();
            ReportingStats.Stop();
        }
    }
}
