﻿using Curse.Friends.Configuration;
using Curse.Friends.Data;
using Curse.Friends.Data.Search;
using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Friends.SearchTests
{
    class Program
    {
        static void Main(string[] args)
        {

            StorageConfiguration.Initialize("FriendsTester", "US-East");

            //EmailSearchModel.DeleteIndex();
            //EmailSearchModel.SetupIndex();
            //new EmailSearchModel() { EmailAddress = "mcomperda@curse.com", FriendCount = 1, UserID = 1 }.Index();
            //return;
            
            //PopulateUserIndex();  

            FriendHintSearchIndexer.CreateForUser(817369);

            StorageConfiguration.Shutdown();
            
        }

        static void PopulateUserIndex()
        {
            //UsernameSearchModel.DeleteIndex();
            //UsernameSearchModel.SetupIndex();
            
            var list = new List<UsernameSearchModel>();

            var random = new Random();

            using (var conn = new SqlConnection("Data Source=sql02-dev.curse.us;Initial Catalog=AuthService;Integrated Security=true;MultipleActiveResultSets=True;Max Pool Size=1024;MultiSubnetFailover=True;"))
            {
                conn.Open();
                using (var cmd = conn.CreateCommand())
                {
                    cmd.CommandText = "select _uid, _username from users order by _uid";
                    using (var reader = cmd.ExecuteReader())
                    {
                        var i = 0;
                        while (reader.Read())
                        {
                            
                            var model = new UsernameSearchModel
                            {
                                Username = reader.GetString(1),
                                UserID = reader.GetInt32(0),
                                FriendCount = 0
                            };


                            list.Add(model);

                            UsernameSearchModel.IndexMany(list, 10000);
                            if(++i % 10000 == 0 )
                            {
                                Console.WriteLine("Indexed " + i);
                            }
                        }
                    }
                }

                UsernameSearchModel.IndexMany(list, 10000);
            }

        }
    }
}
