﻿using System.Net;
using Curse.ServiceClients;

namespace Curse.Friends.ServiceClients
{
    public class FriendsServiceClients : BaseServices
    {

        public static void Initialize(string encryptionKey, int iterations, string apiKey)
        {
            FriendsServiceClientsTokenProvider.Initialize(encryptionKey, iterations, apiKey);
        }

        static FriendsServiceClients()
        {
            ServicePointManager.ServerCertificateValidationCallback += (sender, cert, chain, sslPolicyErrors) => true;            
            ServicesConfiguration.SetDefaultUrls();
            ServicesConfiguration.LogProvider = new FriendsServiceClientsLogProvider();
            ServicesConfiguration.TokenProvider = new FriendsServiceClientsTokenProvider();            
        }
     
        public static FriendsServiceClients Instance { get { return Nested.Instance; } }

        private class Nested
        {
            // Explicit static constructor to tell C# compiler
            // not to mark type as beforefieldinit
            static Nested()
            {
            }

            internal static readonly FriendsServiceClients Instance = new FriendsServiceClients();
        }
    }
}
