﻿using System;
using System.Collections.Generic;
using Curse.Logging;
using Curse.ServiceClients;
using Curse.ServiceEncryption;

namespace Curse.Friends.ServiceClients
{
    public class FriendsServiceClientsTokenProvider : IServicesTokenProvider
    {
        private static string _apiKey;

        internal static void Initialize(string encryptionKey, int iterations, string apiKey)
        {
            _apiKey = apiKey;
            EncryptionToken.Initialize(encryptionKey, iterations);
        }

        public string GetToken()
        {
            if (_apiKey == null)
            {
                Logger.Warn("FriendsServiceClientsTokenProvider: ApiKey has not been initialized!");
            }            

            var token = EncryptionToken.FromDictonary(new Dictionary<string, string>
                {
                    { "ApiKey", _apiKey },
                    { "Timestamp", EncryptionToken.ConvertToEpoch(DateTime.UtcNow).ToString() }
                });

            return token.Value;
        }
    }
}
