using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class AccountService : BaseWebServiceClient
    {
        public AccountService(string url) : base(url)
        {
            
        }

		public ServiceResponse<PushPreferencesResponse> GetPushPreferences() {
			return Get<PushPreferencesResponse>("account/preferences/push");
		}

		public ServiceResponse ChangePushPreferences(PushNotificationPreferencesRequest request) {
			return Post("account/preferences/push", request);
		}

		public ServiceResponse<UserPrivacySettingsContract> GetPrivacyPreferences() {
			return Get<UserPrivacySettingsContract>("account/preferences/privacy");
		}

		public ServiceResponse ChangePrivacyPreferences(UserPrivacySettingsContract request) {
			return Post("account/preferences/privacy", request);
		}

		public ServiceResponse SetIdle(SetIdleRequest request) {
			return Post("account/status/idle", request);
		}

		public ServiceResponse SetActive(SetActiveRequest request) {
			return Post("account/status/active", request);
		}

		public ServiceResponse ChangeStatus(ChangeStatusRequest request) {
			return Post("account/status/connection", request);
		}

		public ServiceResponse ChangeGameStatus(ChangeGameStatusRequest request) {
			return Post("account/status/game", request);
		}

		public ServiceResponse ChangeWatchingStatus(ChangeWatchingStatusRequest request) {
			return Post("account/status/watching", request);
		}

		public ServiceResponse ChangeProfile(ChangeProfileRequest request) {
			return Post("account/profile", request);
		}

		public ServiceResponse<UserProfileNotification> GetProfile() {
			return Get<UserProfileNotification>("account/profile");
		}

		public ServiceResponse<ChangePasswordStatus> ChangePassword(ChangePasswordRequest request) {
			return Post<ChangePasswordStatus>("account/password", request);
		}

		public ServiceResponse<ChangeEmailStatus> ChangeEmail(ChangeEmailRequest request) {
			return Post<ChangeEmailStatus>("account/email", request);
		}

		public ServiceResponse<GetChangeUsernameAvailabilityResponse> GetChangeUsernameAvailability() {
			return Get<GetChangeUsernameAvailabilityResponse>("account/rename");
		}

		public ServiceResponse<ChangeUsernameStatus> ChangeUsername(ChangeUsernameRequest request) {
			return Post<ChangeUsernameStatus>("account/rename", request);
		}

		public ServiceResponse<UserClientSettingsNotification> GetClientSettings() {
			return Get<UserClientSettingsNotification>("account/preferences/client-settings");
		}

		public ServiceResponse<UserClientSettingsNotification> ChangeClientSettings(ChangeClientSettingsRequest request) {
			return Post<UserClientSettingsNotification>("account/preferences/client-settings", request);
		}

		public ServiceResponse<AccountEntitlementsResponse> GetAccountEntitlements() {
			return Get<AccountEntitlementsResponse>("account/entitlements");
		}

		public ServiceResponse<EmoteContract[]> GetAllowedEmotes() {
			return Get<EmoteContract[]>("account/emotes");
		}

		public ServiceResponse<GetTwitchEmotesResponse> GetTwitchEmotes() {
			return Get<GetTwitchEmotesResponse>("account/twitch-emotes");
		}

		public ServiceResponse<GetTwitchTokenResponse> GetTwitchToken() {
			return Get<GetTwitchTokenResponse>("account/twitch-token");
		}


    }
}
