using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class CallsAdminService : BaseWebServiceClient
    {
        public CallsAdminService(string url) : base(url)
        {
            
        }

		public ServiceResponse VoiceHostCallback(VoiceHostCallbackRequest request) {
			return Post("calls/api/host-callback", request);
		}

		public ServiceResponse KickUsersFromCall(KickUsersFromCallRequest request) {
			return Post("calls/api/kick", request);
		}

		public ServiceResponse CheckMuteUserPermission(CheckVoicePermissionsRequest request) {
			return Post("calls/api/check-permissions/mute", request);
		}

		public ServiceResponse CheckDeafenUserPermission(CheckVoicePermissionsRequest request) {
			return Post("calls/api/check-permissions/deafen", request);
		}

		public ServiceResponse CheckKickUserPermission(CheckVoicePermissionsRequest request) {
			return Post("calls/api/check-permissions/kick", request);
		}

		public ServiceResponse<GetModerationStatusResponse> GetModerationStatus(Guid groupID, int userID) {
			return Get<GetModerationStatusResponse>(string.Format("calls/api/moderation-status/{0}/{1}", groupID, userID));
		}


    }
}
