using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class ImagesAdminService : BaseWebServiceClient
    {
        public ImagesAdminService(string url) : base(url)
        {
            
        }

		public ServiceResponse<ImageMetadataResponse> FindImage(FileRegion region, string imageKey) {
			return Get<ImageMetadataResponse>(string.Format("images/api/{0}/{1}", region, imageKey));
		}

		public ServiceResponse PurgeImage(FileRegion region, string imageKey) {
			return Delete(string.Format("images/api/{0}/{1}", region, imageKey));
		}


    }
}
