using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class InvitationsService : BaseWebServiceClient
    {
        public InvitationsService(string url) : base(url)
        {
            
        }

		public ServiceResponse<GroupInvitationNotification> Get(string inviteCode) {
			return Get<GroupInvitationNotification>(string.Format("invitations/{0}", inviteCode));
		}

		public ServiceResponse<GetInvitationDisplayDetailsResponse> GetDisplayDetails(string inviteCode) {
			return Get<GetInvitationDisplayDetailsResponse>(string.Format("invitations/{0}/display", inviteCode));
		}

		public ServiceResponse<GroupInvitationRedeemResponse> Redeem(string inviteCode) {
			return Post<GroupInvitationRedeemResponse>(string.Format("invitations/{0}", inviteCode));
		}


    }
}
