using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class LinkedCommunitiesService : BaseWebServiceClient
    {
        public LinkedCommunitiesService(string url) : base(url)
        {
            
        }

		public ServiceResponse Resync(string communityID) {
			return Post(string.Format("linked-communities/{0}/resync", communityID));
		}

		public ServiceResponse<ExternalCommunityEmoticonContract[]> GetSyncedEmotes(AccountType type, string communityID) {
			return Get<ExternalCommunityEmoticonContract[]>(string.Format("linked-communities/{0}/{1}/emotes", type, communityID));
		}

		public ServiceResponse Link(AccountType type, Guid groupID, string communityID) {
			return Post(string.Format("linked-communities/{0}/{2}/links/{1}", type, groupID, communityID));
		}

		public ServiceResponse Unlink(AccountType type, Guid groupID, string communityID) {
			return Delete(string.Format("linked-communities/{0}/{2}/links/{1}", type, groupID, communityID));
		}

		public ServiceResponse<ExternalCommunityLinkContract[]> GetLinkedCommunities(Guid groupID) {
			return Get<ExternalCommunityLinkContract[]>(string.Format("linked-communities/{0}", groupID));
		}

		public ServiceResponse<ExternalCommunityLinkContract> ChangeCommunitySettings(Guid groupID, AccountType type, string communityID, ChangeCommunitySettingsRequest request) {
			return Post<ExternalCommunityLinkContract>(string.Format("linked-communities/{0}/{1}/{2}/settings", groupID, type, communityID), request);
		}

		public ServiceResponse<SyncedCommunityMembershipResponse> GetCommunityMemberships() {
			return Get<SyncedCommunityMembershipResponse>("linked-communities/memberships");
		}

		public ServiceResponse<PremiumMemberSearchResponse> GetPremiumMembers(AccountType type, string communityID, string query, Guid? groupID, int? pageSize, int? pageNumber) {
			return Get<PremiumMemberSearchResponse>(string.Format("linked-communities/{0}/{1}/subscribers", type, communityID) + string.Format("?query={0}&groupID={1}&pageSize={2}&pageNumber={3}",Uri.EscapeDataString(query),groupID,pageSize,pageNumber));
		}

		public ServiceResponse<FollowTwitchChannelResponse> FollowChannel(string communityID) {
			return Post<FollowTwitchChannelResponse>(string.Format("linked-communities/twitch/{0}/follow", communityID));
		}


    }
}
