using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class LinkedGuildsService : BaseWebServiceClient
    {
        public LinkedGuildsService(string url) : base(url)
        {
            
        }

		public ServiceResponse LinkGuild(AccountType type, int region, string server, string guildName, Guid groupID, LinkGuildRequest request) {
			return Post(string.Format("linked-guilds/{0}/{1}/{2}/{3}/links/{4}", type, region, server, guildName, groupID), request);
		}

		public ServiceResponse UnlinkGuild(AccountType type, int region, string server, string guildName, Guid groupID) {
			return Delete(string.Format("linked-guilds/{0}/{1}/{2}/{3}/links/{4}", type, region, server, guildName, groupID));
		}

		public ServiceResponse<GuildDetailsContract[]> GetMyGuilds(AccountType type) {
			return Get<GuildDetailsContract[]>(string.Format("linked-guilds/{0}", type));
		}


    }
}
