using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class RegisterService : BaseWebServiceClient
    {
        public RegisterService(string url) : base(url)
        {
            
        }

		public ServiceResponse<RegisterResponse> Register(RegisterRequest registerRequest) {
			return Post<RegisterResponse>("register", registerRequest);
		}

		public ServiceResponse<bool> CheckUsername(string username) {
			return Post<bool>("register/check-username", username);
		}

		public ServiceResponse<RegisterTempResponse> RegisterTempAccount(RegisterTempRequest registerRequest) {
			return Post<RegisterTempResponse>("register/create-temp", registerRequest);
		}

		public ServiceResponse<RegisterResponse> ClaimTempAccount(ClaimTempRequest claimRequest) {
			return Post<RegisterResponse>("register/claim-temp", claimRequest);
		}


    }
}
