using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class ReportingService : BaseWebServiceClient
    {
        public ReportingService(string url) : base(url)
        {
            
        }

		public ServiceResponse Usage(UsageProfile usageProfile) {
			return Post("reporting/usage", usageProfile);
		}

		public ServiceResponse ReportEvent(EventReportContract[] data) {
			return Post("reporting/events", data);
		}

		public ServiceResponse TrackPartnerUpsell(UserTrackingType trackingType) {
			return Post(string.Format("reporting/tracking/{0}", trackingType));
		}


    }
}
