using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class StatsService : BaseWebServiceClient
    {
        public StatsService(string url) : base(url)
        {
            
        }

		public ServiceResponse Realtime(StatsPayload payload) {
			return Post("stats/realtime", payload);
		}

		public ServiceResponse Periodic(StatsPayload payload) {
			return Post("stats/periodic", payload);
		}

		public ServiceResponse<HostStats[]> GetHostStats(long startTimestamp) {
			return Get<HostStats[]>("stats/host-stats" + string.Format("?startTimestamp={0}",startTimestamp));
		}

		public ServiceResponse<AggregateStats[]> GetAggretateStats(long startTimestamp) {
			return Get<AggregateStats[]>("stats/aggregate-stats" + string.Format("?startTimestamp={0}",startTimestamp));
		}

		public ServiceResponse Regional(StatsPayload payload) {
			return Post("stats/regional", payload);
		}

		public ServiceResponse Status(HostStatusContract request) {
			return Post("stats/status", request);
		}


    }
}
