using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class TwitchInteropService : BaseWebServiceClient
    {
        public TwitchInteropService(string url) : base(url)
        {
            
        }

		public ServiceResponse<Object> GetCheerEmoteConfig() {
			return Get<Object>("twitch/bits/config");
		}

		public ServiceResponse<Object> GetChatProperties(string externalID) {
			return Get<Object>(string.Format("twitch/chat/{0}/properties", externalID));
		}

		public ServiceResponse<Object> GetHostInfo(string externalID) {
			return Get<Object>(string.Format("twitch/hosts/{0}", externalID));
		}


    }
}
