using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class ClientBugReportAttachmentContract{
	public int AttachmentID { get; set; }
	public int BugReportID { get; set; }
	public string Filename { get; set; }
	public long FileLength { get; set; }
	public Byte[] FileContents { get; set; }
	public long CreatedTimestamp { get; set; }
}
public class BugReport{
	public string ClientVersion { get; set; }
	public string Title { get; set; }
	public BugReportType Type { get; set; }
	public long? StackTraceHash { get; set; }
	public string UserSettings { get; set; }
	public string SystemInformation { get; set; }
	public string IncompatibleProcesses { get; set; }
	public string GameConfiguration { get; set; }
	public string LogData { get; set; }
	public BugReportAttachment[] Attachments { get; set; }
	public string ExceptionDetails { get; set; }
	public string ApplicationLocation { get; set; }
	public string Message { get; set; }
	public int? LastAttemptedVoiceHostID { get; set; }
	public int? OverlayExitCode { get; set; }
	public Byte? OverlayGameState { get; set; }
	public BugReportProcess[] RunningProcesses { get; set; }
	public DevicePlatform Platform { get; set; }
	public int? CallQuality { get; set; }
	public string TimeConfiguration { get; set; }
}
public enum BugReportType {
	CrashReport = 1,
	BugOrDefect = 2,
	FeatureSuggestion = 3,
	LoginIssue = 4,
	StartupIssue = 5,
	OtherIssue = 6,
	AutoReport = 7,
	GameCrash = 8,
	CallQuality = 9,
	PostiveFeedback = 10,
	NegativeFeedback = 11,
}
public class BugReportAttachment{
	public string FileName { get; set; }
	public Byte[] FileContents { get; set; }
}
public class BugReportProcess{
	public int ID { get; set; }
	public string FullName { get; set; }
	public string Name { get; set; }
	public DateTime StartTime { get; set; }
	public BugReportProcessType Type { get; set; }
}
public enum BugReportProcessType {
	Executable = 1,
	Library = 2,
}
public class Feedback{
	public FeedbackType FeedbackType { get; set; }
	public string ClientVersion { get; set; }
	public DevicePlatform Platform { get; set; }
	public string LogData { get; set; }
	public string Message { get; set; }
	public int? LastAttemptedVoiceHostID { get; set; }
}
public enum FeedbackType {
	Positive = 0,
	Negative = 1,
}
public class UserReport{
	public UserReportType Type { get; set; }
	public UserReportReason Reason { get; set; }
	public int UserID { get; set; }
	public string Description { get; set; }
}

}
