using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class VoiceHostCallbackRequest{
	public Guid GroupID { get; set; }
	public int[] UserIDs { get; set; }
	public VoiceHostCallbackType ChangeType { get; set; }
	public string InviteCode { get; set; }
}
public enum VoiceHostCallbackType {
	CallStarted = 0,
	CallEnded = 1,
	UsersJoined = 2,
	UsersLeft = 3,
}
public class KickUsersFromCallRequest{
	public int RequestorUserID { get; set; }
	public Guid GroupID { get; set; }
	public int[] UserIDs { get; set; }
	public KickReason Reason { get; set; }
}
public enum KickReason {
	UserRemoved = 0,
	UserLeft = 1,
}
public class CheckVoicePermissionsRequest{
	public Guid GroupID { get; set; }
	public int RequestingUserID { get; set; }
	public int AffectedUserID { get; set; }
}
public class GetModerationStatusResponse{
	public VoicePermissions Permissions { get; set; }
	public bool IsMuted { get; set; }
	public bool IsDeafened { get; set; }
}
public class VoicePermissions{
	public int BestRoleRank { get; set; }
	public bool CanSpeak { get; set; }
	public bool CanModKick { get; set; }
	public bool CanModMute { get; set; }
	public bool CanModDeafen { get; set; }
}
public class ConversationCallRequest{
	public string ClientVersion { get; set; }
	public bool Force { get; set; }
	public bool SendInvitation { get; set; }
	public CallMode Mode { get; set; }
}
public class AdHocCallRequest{
	public int? GameID { get; set; }
	public string UserDisplayName { get; set; }
	public string ClientVersion { get; set; }
}
public class HandshakeAutoMatchResponse{
	public bool HasMatches { get; set; }
	public int PlayerCount { get; set; }
	public HandshakeUserContract[] Users { get; set; }
	public string ExistingInviteCode { get; set; }
	public string ExistingInstanceCode { get; set; }
}
public class HandshakeUserContract{
	public int UserID { get; set; }
	public string DisplayName { get; set; }
	public DateTime Timestamp { get; set; }
	public bool Declined { get; set; }
	public bool IsRecent { get; set; }
}
public class HandshakeAutoMatchRequest{
	public int Attempt { get; set; }
	public string DisplayName { get; set; }
	public int? GameID { get; set; }
}
public class AutoMatchCallRequest{
	public int GameID { get; set; }
	public string UserDisplayName { get; set; }
	public string ClientVersion { get; set; }
	public long AutoMatchKey { get; set; }
}
public class AdHocCallDisplayDetailsResponse{
	public int UserID { get; set; }
	public string Username { get; set; }
	public string InviteCode { get; set; }
	public long Timestamp { get; set; }
}
public class DeafenUserRequest{
	public int UserID { get; set; }
	public bool Mute { get; set; }
}
public class MoveUserRequest{
	public Guid TargetGroupID { get; set; }
}
public class ReportGameSessionsRequest{
	public GameSessionMetricsContract[] GameSessionMetrics { get; set; }
}
public class GameSessionMetricsContract{
	public int GameID { get; set; }
	public bool Successful { get; set; }
	public int ExitCode { get; set; }
	public string GameStateName { get; set; }
	public Byte GameState { get; set; }
}

}
