using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class ConversationAttachmentEditRequest{
	public string MessageID { get; set; }
	public long MessageTimestamp { get; set; }
	public string Title { get; set; }
}
public class ConversationDeleteAttachmentRequest{
	public string MessageID { get; set; }
	public long MessageTimestamp { get; set; }
}
public class ConversationSearchItem{
	public ConversationMessageNotification Message { get; set; }
	public string Highlight { get; set; }
}
public class ConversationSearchRequest{
	public string ConversationID { get; set; }
	public string Keyword { get; set; }
	public bool SelfAuthored { get; set; }
	public bool SelfLiked { get; set; }
	public bool SelfMentioned { get; set; }
	public ContentTag[] ContentTags { get; set; }
	public DateTime? StartDate { get; set; }
	public DateTime? EndDate { get; set; }
	public int PerPage { get; set; }
	public int Page { get; set; }
	public string HighlightToken { get; set; }
}
public class ConversationCreateMessageRequest{
	public string MachineKey { get; set; }
	public Guid AttachmentID { get; set; }
	public Guid ClientID { get; set; }
	public string Body { get; set; }
	public int AttachmentRegionID { get; set; }
}
public class ConversationEditMessageRequest{
	public string Body { get; set; }
	public int[] Mentions { get; set; }
}
public class ConversationMarkReadRequest{
	public string MessageID { get; set; }
	public long Timestamp { get; set; }
	public string MachineKey { get; set; }
}
public class ConversationFlagSpamRequest{
	public bool IsSpam { get; set; }
}

}
