using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class IdentityMergeStateContract{
	public int CurseUserID { get; set; }
	public string DisplayName { get; set; }
	public IdentityMergeFailureReason FailureReason { get; set; }
	public IdentityMergeStatus Status { get; set; }
	public string TwitchUserID { get; set; }
	public string Username { get; set; }
}
public class LoginResponse{
	public LoginStatus Status { get; set; }
	public string StatusMessage { get; set; }
	public LoginSession Session { get; set; }
	public long Timestamp { get; set; }
	public string TwitchUsernameReservationToken { get; set; }
}
public enum LoginStatus {
	Success = 1,
	UnauthorizedLogin = 3,
	InvalidPassword = 4,
	UnknownUsername = 5,
	UnknownEmail = 6,
	CorruptLibrary = 102,
	SubscriptionMismatch = 104,
	SubscriptionExpired = 105,
	MissingGrant = 108,
	GeneralError = 1000,
}
public class LoginSession{
	public int UserID { get; set; }
	public string Username { get; set; }
	public string DisplayName { get; set; }
	public string SessionID { get; set; }
	public string Token { get; set; }
	public string EmailAddress { get; set; }
	public bool EffectivePremiumStatus { get; set; }
	public bool ActualPremiumStatus { get; set; }
	public int SubscriptionToken { get; set; }
	public long Expires { get; set; }
	public long RenewAfter { get; set; }
	public bool IsTemporaryAccount { get; set; }
	public bool IsMerged { get; set; }
	public UserBanType Bans { get; set; }
}
public class LoginRequest{
	public string Username { get; set; }
	public string Password { get; set; }
}
public class RenewTokenResponseContract{
	public string Token { get; set; }
	public long Expires { get; set; }
	public long RenewAfter { get; set; }
}
public class LoginWithNetworkSessionRequest{
	public int SiteID { get; set; }
	public string SessionID { get; set; }
}
public class TwitchOAuthResponse{
	public TwitchOAuthStatus Status { get; set; }
	public LoginSession Session { get; set; }
	public long Timestamp { get; set; }
	public string MergeToken { get; set; }
	public string TwitchUsername { get; set; }
	public string TwitchDisplayName { get; set; }
	public string TwitchAvatar { get; set; }
	public string TwitchUserID { get; set; }
}
public enum TwitchOAuthStatus {
	Success = 0,
	FailedValidation = 1,
	FailedInvalidOAuthCode = 2,
	FailedOAuthError = 3,
	RequiresMerge = 4,
}
public class TwitchOAuthRequest{
	public string ClientID { get; set; }
	public string Code { get; set; }
	public string RedirectUri { get; set; }
	public string State { get; set; }
}
public class TwitchMergeResponse{
	public TwitchMergeStatus Status { get; set; }
	public LoginSession Session { get; set; }
}
public enum TwitchMergeStatus {
	Success = 0,
	FailedValidation = 1,
	FailedInvalidOAuthCode = 2,
	FailedInvalidMergeToken = 3,
	FailedOAuthError = 4,
	FailedGeneralError = 5,
	FailedUnknownUser = 6,
	FailedInvalidPassword = 7,
	FailedCurseAccountMerged = 8,
	FailedTwitchAccountMerged = 9,
	FailedDeletedAccount = 10,
}
public class TwitchMergeNewRequest{
	public string MergeToken { get; set; }
}
public class TwitchMergeExistingRequest{
	public string MergeToken { get; set; }
	public string Username { get; set; }
	public string Password { get; set; }
}
public class TwitchMergeTempAccountRequest{
	public string TempAccountToken { get; set; }
	public string MergeToken { get; set; }
}
public class FuelAuthorizationResponseContract{
	public string AccessToken { get; set; }
	public string RefreshToken { get; set; }
	public long Expires { get; set; }
	public string[] Scopes { get; set; }
	public string ErrorMessage { get; set; }
	public string Status { get; set; }
	public string Error { get; set; }
}
public class RegisterResponse{
	public RegisterStatus Status { get; set; }
	public string StatusMessage { get; set; }
	public LoginSession Session { get; set; }
}
public enum RegisterStatus {
	Success = 0,
	EmailInUse = 1,
	UsernameInUse = 2,
	InvalidEmail = 3,
	InvalidProfile = 4,
	InvalidUsername = 5,
	InvalidPassword = 6,
	GeneralError = 7,
	TooManyAccountsSameIp = 8,
}
public class RegisterRequest{
	public string Username { get; set; }
	public string Password { get; set; }
	public string Email { get; set; }
	public bool Newsletter { get; set; }
}
public class RegisterTempResponse{
	public string TempAccountToken { get; set; }
	public RegisterStatus Status { get; set; }
	public string StatusMessage { get; set; }
	public LoginSession Session { get; set; }
}
public class RegisterTempRequest{
	public string Username { get; set; }
}
public class ClaimTempRequest{
	public string TempAccountToken { get; set; }
	public string Email { get; set; }
	public string Password { get; set; }
}

}
