using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class FriendsHostStats{
	public int MemoryUsageKilobytes { get; set; }
	public long ReceivedBitsPerSecond { get; set; }
	public long SentBitsPerSecond { get; set; }
	public Double ProcessorUtilization { get; set; }
	public Double RequestsPerSecond { get; set; }
	public int ConcurrentConnections { get; set; }
	public Double MessagesPerSecond { get; set; }
	public Double MessagesPerMinute { get; set; }
	public int NewMessages { get; set; }
	public Dictionary<int, int>  NewMessagesByPlatform { get; set; }
	public DateTime StartDate { get; set; }
	public int PeakConnections { get; set; }
	public int IdentitiesCreated { get; set; }
	public int IdentitiesDeclined { get; set; }
	public int FriendshipsRemoved { get; set; }
	public int FriendshipsDeclined { get; set; }
	public int FriendshipsConfirmed { get; set; }
	public int FriendshipsRequested { get; set; }
	public int MessagesRecipients { get; set; }
	public int MutalFriendSuggestionsCreated { get; set; }
	public int PlatformFriendSuggestionsCreated { get; set; }
	public int GameFriendSuggestionsCreated { get; set; }
	public long TotalSuggestionsCreated { get; set; }
	public int SuggestionsDeclined { get; set; }
	public int SuggestionsAccepted { get; set; }
	public int TotalProfilesViewed { get; set; }
	public int UniqueProfilesViewed { get; set; }
	public int TotalProfileUpdates { get; set; }
	public int UniqueProfileUpdates { get; set; }
	public int SearchesPerformed { get; set; }
	public long TotalGameNotifications { get; set; }
	public Dictionary<int, int>  GameNotifications { get; set; }
	public Dictionary<int, int>  PlatformIdentitiesDeclinedByType { get; set; }
	public Dictionary<int, int>  PlatformIdentitiesCreatedByType { get; set; }
	public Dictionary<int, int>  CurrentGames { get; set; }
	public int VoiceInvitationsSent { get; set; }
	public int VoiceInvitationsDeclined { get; set; }
	public FriendsQueueStats[] QueueStats { get; set; }
	public Dictionary<int, int>  FriendSyncsByResult { get; set; }
	public int NewGroupMessages { get; set; }
	public int NewPrivateGroupMessages { get; set; }
	public Dictionary<int, int>  NewGroupMessagesByPlatform { get; set; }
	public int GroupVoiceInvitationsSent { get; set; }
	public int GroupVoiceInvitationsDeclined { get; set; }
	public Double GroupMessagesPerMinute { get; set; }
	public Double GroupMessagesPerSecond { get; set; }
	public Double PrivateGroupMessagesPerMinute { get; set; }
	public Double PrivateGroupMessagesPerSecond { get; set; }
	public Dictionary<int, int>  GroupsCreatedByType { get; set; }
	public int GroupsCreated { get; set; }
	public Double TotalMessagesPerMinute { get; set; }
	public Double TotalMessagesPerSecond { get; set; }
	public int TotalVoiceInvitationsSent { get; set; }
	public int TotalInvitationsDeclined { get; set; }
	public int ImagesUploaded { get; set; }
}
public class FriendsQueueStats{
	public string QueueName { get; set; }
	public long TotalMessagesProcessed { get; set; }
	public int CurrentlyProcessing { get; set; }
	public Double AverageProcessingTimeMs { get; set; }
	public Double BestProcessingTimeMs { get; set; }
	public Double WorstProcessingTimeMs { get; set; }
	public Double AverageQueuedTimeMs { get; set; }
	public Double BestQueuedTimeMs { get; set; }
	public Double WorstQueuedTimeMs { get; set; }
}
public class FriendsRegionStats{
	public int RegionID { get; set; }
	public DateTime StartDate { get; set; }
	public long TotalUsers { get; set; }
	public long TotalFriendships { get; set; }
	public int MaxFriendsPerUser { get; set; }
	public Double AverageFriendsPerUser { get; set; }
	public Double AverageFriendsPerEngagedUser { get; set; }
	public int UsersWithFriends { get; set; }
	public int MedianFriendsPerUser { get; set; }
	public long TotalFavorites { get; set; }
	public long TotalPendingFriendRequests { get; set; }
	public long TotalOutOfRegionFriends { get; set; }
	public long OnlineUserCount { get; set; }
	public long ActiveUserCount { get; set; }
	public long ActivelyGaming { get; set; }
	public Dictionary<UserConnectionStatus, long>  UserCountByStatus { get; set; }
	public Dictionary<int, long>  UserCountByCurrentGame { get; set; }
	public Dictionary<int, long>  IdentitiesByGame { get; set; }
	public long TotalGameIdentities { get; set; }
	public Dictionary<FriendPlatform, long>  IdentitiesByPlatform { get; set; }
	public long TotalPlatformIdentities { get; set; }
	public int UsersWithProfiles { get; set; }
	public int TotalFriendSuggestions { get; set; }
	public Dictionary<int, int>  FriendSuggestionsByStatus { get; set; }
	public Dictionary<int, int>  FriendSuggestionsByType { get; set; }
	public Dictionary<int, int>  FriendSuggestionsByGame { get; set; }
	public Dictionary<int, int>  FriendSuggestionsByPlatform { get; set; }
	public Dictionary<int, int>  FriendSuggestionsAcceptedByGame { get; set; }
	public Dictionary<int, int>  FriendSuggestionsDeclinedByGame { get; set; }
	public Dictionary<int, int>  FriendSuggestionsPendingByGame { get; set; }
	public Dictionary<int, int>  FriendSuggestionsAcceptedByPlatform { get; set; }
	public Dictionary<int, int>  FriendSuggestionsDeclinedByPlatform { get; set; }
	public Dictionary<int, int>  FriendSuggestionsPendingByPlatform { get; set; }
	public Dictionary<int, int>  TotalGroupsByType { get; set; }
	public Dictionary<int, int>  TotalGroupsByStatus { get; set; }
	public Dictionary<int, int>  GroupsCountBySize { get; set; }
	public int TotalGroups { get; set; }
	public Double AverageGroupSize { get; set; }
	public Double EngagedAverageGroupSize { get; set; }
	public int MaxGroupSize { get; set; }
	public int TotalGroupMembers { get; set; }
	public int GroupsWithPushToTalk { get; set; }
}

}
