using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class StatsPayload{
	public int RegionID { get; set; }
	public int HostTypeID { get; set; }
	public string HostTypeName { get; set; }
	public string HostName { get; set; }
	public string StatsJson { get; set; }
}
public class HostStats{
	public int RegionID { get; set; }
	public int HostID { get; set; }
	public string HostName { get; set; }
	public int HostTypeID { get; set; }
	public string HostTypeSlug { get; set; }
	public string HostTypeName { get; set; }
	public int HostStatus { get; set; }
	public long Timestamp { get; set; }
	public FriendsHostStats Stats { get; set; }
}
public class AggregateStats{
	public int RegionID { get; set; }
	public long Timestamp { get; set; }
	public FriendsRegionStats Stats { get; set; }
}
public class HostStatusContract{
	public int RegionID { get; set; }
	public string HostName { get; set; }
	public int HostTypeID { get; set; }
	public string HostTypeName { get; set; }
	public HostStatus HostStatus { get; set; }
}
public enum HostStatus {
	Offline = 1,
	Starting = 2,
	Started = 3,
	ShuttingDown = 4,
	Decomissioned = 5,
}

}
