﻿using System;
using System.Xml.Serialization;
using Curse.Friends.Configuration;

namespace Curse.Friends.SessionsWebService.Configuration
{

    [XmlRoot("Service")]
    public class SessionsWebServiceConfiguration
    {
        public static readonly SessionsWebServiceConfiguration Current;

        static SessionsWebServiceConfiguration()
        {
            Current = ConfigurationHelper.LoadConfiguration<SessionsWebServiceConfiguration>(FriendsServiceConfiguration.Mode, "SessionsWebServiceConfiguration");
            Current.NotificationServiceUrl = string.Format(Current.NotificationServiceUrlFormat, StorageConfiguration.CurrentRegion.DnsPrefix);
            
        }

        public string NotificationServiceUrl { get; set; }

        [XmlElement("NotificationServiceUrlFormat")]
        public string NotificationServiceUrlFormat { get; set; }
    }
}