﻿using System;
using Curse.Extensions;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.SessionsWebService.Contracts
{
    public class CreateSessionRequest : BaseRequestContract
    {
        public Guid MachineKey { get; set; }
        public DevicePlatform Platform { get; set; }

        /// <summary>
        /// Mobile device token (Apple or Android)
        /// </summary>
        public string DeviceID { get; set; }

        /// <summary>
        /// Apple-only device token for PushKit call notifications.
        /// </summary>
        public string PushKitToken { get; set; }

        protected override bool DoValidate()
        {
            if(MachineKey == Guid.Empty)
            {
                _validationMessage = "MachineKey must be a valid Guid";
                return false;
            }

            if (DeviceID.SafeLength() > 256)
            {
                _validationMessage = "DeviceID is too long";
                return false;
            }

            if (PushKitToken.SafeLength() > 256)
            {
                _validationMessage = "PushKitToken is too long";
                return false;
            }
            
            return true;
        }
    }
}