﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Curse.Friends.Statistics.Models;
using Newtonsoft.Json;
using Curse.Friends.Enums;
using Curse.Extensions;

namespace Curse.Friends.Spark
{
    public static class SparkStatsConverter
    {
        public static Dictionary<int, FriendsRegionStats> Convert(string json)
        {
            var stats = JsonConvert.DeserializeObject<SparkStatsContainer>(json);

            var statsByRegion = new Dictionary<int, FriendsRegionStats>();
            
            foreach (var stat in stats.Stats)
            {
                var region = int.Parse(stat.Key);
                var isGlobalRegion = region == 0;
                if (region == 0)
                {
                    region = 1;
                }

                if (!statsByRegion.ContainsKey(region))
                {
                    statsByRegion.Add(region, new FriendsRegionStats());
                }

                var sparkStats = stat.Value;
                var regionStats = statsByRegion[region];
                
                regionStats.StartDate = stats.Timestamps.StartDate.GetNearestQuarter();
                

                if (!isGlobalRegion)
                {
                    // User and Friend Stats
                    regionStats.TotalUsers = sparkStats.UserStats.Count;
                    regionStats.AverageFriendsPerEngagedUser = sparkStats.UserStats.EngagedAvgFriends;
                    regionStats.AverageFriendsPerUser = sparkStats.UserStats.OverallAvgFriends;
                    regionStats.UserCountByCurrentGame = sparkStats.UserStats.GameCounts.Where(p => p.Key > 0).ToDictionary(p => p.Key, p => p.Value);
                    regionStats.UserCountByStatus = new Dictionary<UserConnectionStatus, long>();
                    foreach (var kvp in sparkStats.UserStats.StatusCounts)
                    {
                        regionStats.UserCountByStatus[(UserConnectionStatus)kvp.Key] = kvp.Value;
                    }
                    regionStats.MaxFriendsPerUser = sparkStats.UserStats.MaxFriends;
                    regionStats.UsersWithProfiles = sparkStats.UserStats.ProfileCount;
                    regionStats.UsersWithFriends = sparkStats.UserStats.UsersWithFriends;
                    regionStats.TotalFriendships = sparkStats.UserStats.TotalFriendships;
                    
                    if (sparkStats.FriendshipStats.StatusCounts.ContainsKey((int) FriendshipStatus.AwaitingMe))
                    {
                        regionStats.TotalPendingFriendRequests = sparkStats.FriendshipStats.StatusCounts[(int) FriendshipStatus.AwaitingMe];
                    }

                    regionStats.TotalOutOfRegionFriends = sparkStats.FriendshipStats.ExtraRegionFriendships;
                    regionStats.TotalFavorites = sparkStats.FriendshipStats.FavoriteCount;

                    // General Suggestion Stats
                    regionStats.TotalFriendSuggestions = sparkStats.FriendSuggestionStats.Count;
                    regionStats.FriendSuggestionsByType = sparkStats.FriendSuggestionStats.TypeCounts;
                    regionStats.FriendSuggestionsByStatus = sparkStats.FriendSuggestionStats.StatusCounts;
                    regionStats.FriendSuggestionsByPlatform = sparkStats.FriendSuggestionStats.StatusCounts;

                    // Game Friend Suggestions
                    regionStats.FriendSuggestionsAcceptedByGame = new Dictionary<int, int>();
                    regionStats.FriendSuggestionsDeclinedByGame = new Dictionary<int, int>();
                    regionStats.FriendSuggestionsPendingByGame = new Dictionary<int, int>();
                    regionStats.FriendSuggestionsByGame = new Dictionary<int, int>();
                    foreach (var kvp in sparkStats.FriendSuggestionStats.GameStats)
                    {
                        if (kvp.Key == 0)
                        {
                            continue;
                        }
                        regionStats.FriendSuggestionsAcceptedByGame[kvp.Key] = kvp.Value.GetValueOrDefault((int)FriendSuggestionStatus.Accepted);
                        regionStats.FriendSuggestionsPendingByGame[kvp.Key] = kvp.Value.GetValueOrDefault((int)FriendSuggestionStatus.Pending);
                        regionStats.FriendSuggestionsDeclinedByGame[kvp.Key] = kvp.Value.GetValueOrDefault((int)FriendSuggestionStatus.Declined);
                        regionStats.FriendSuggestionsByGame[kvp.Key] = kvp.Value.Sum(p => p.Value);
                    }

                    // Platform Friend Suggestions
                    regionStats.FriendSuggestionsAcceptedByPlatform = new Dictionary<int, int>();
                    regionStats.FriendSuggestionsDeclinedByPlatform = new Dictionary<int, int>();
                    regionStats.FriendSuggestionsPendingByPlatform = new Dictionary<int, int>();
                    regionStats.FriendSuggestionsByPlatform = new Dictionary<int, int>();
                    foreach (var kvp in sparkStats.FriendSuggestionStats.PlatformStats)
                    {
                        if (kvp.Key == 0)
                        {
                            continue;
                        }
                        regionStats.FriendSuggestionsAcceptedByPlatform[kvp.Key] = kvp.Value.GetValueOrDefault((int)FriendSuggestionStatus.Accepted);
                        regionStats.FriendSuggestionsPendingByPlatform[kvp.Key] = kvp.Value.GetValueOrDefault((int)FriendSuggestionStatus.Pending);
                        regionStats.FriendSuggestionsDeclinedByPlatform[kvp.Key] = kvp.Value.GetValueOrDefault((int)FriendSuggestionStatus.Declined);
                        regionStats.FriendSuggestionsByPlatform[kvp.Key] = kvp.Value.Sum(p => p.Value);
                    }

                    

                }
                else
                {
                    // Group Stats
                    regionStats.AverageGroupSize = sparkStats.GroupStats.OverallAvgMembers;
                    regionStats.EngagedAverageGroupSize = sparkStats.GroupStats.EngagedAvgMembers;
                    regionStats.GroupsWithPushToTalk = sparkStats.GroupStats.PushToTalkEnabled;
                    regionStats.MaxGroupSize = sparkStats.GroupStats.GroupSizes.OrderByDescending(p => p.Key).Select(p => p.Key).FirstOrDefault();
                    regionStats.TotalGroupMembers = sparkStats.GroupStats.TotalMembers;
                    regionStats.TotalGroups = sparkStats.GroupStats.Count;
                    regionStats.TotalGroupsByStatus = sparkStats.GroupStats.StatusCounts;
                    regionStats.TotalGroupsByType = sparkStats.GroupStats.TypeCounts;
                    regionStats.GroupsCountBySize = sparkStats.GroupStats.GroupSizes;

                    // Friend Hint / Game Identity Stats
                    regionStats.IdentitiesByGame = sparkStats.FriendHintStats.GameHints.Where(p => p.Key > 0).ToDictionary(p => p.Key, p => p.Value);
                    regionStats.IdentitiesByPlatform = new Dictionary<FriendPlatform, long>();
                    foreach (var kvp in sparkStats.FriendHintStats.PlatformHints)
                    {
                        if (kvp.Key == 0)
                        {
                            continue;                            
                        }
                        regionStats.IdentitiesByPlatform[(FriendPlatform)kvp.Key] = kvp.Value;
                    }

                }                
            }

            return statsByRegion;
        }
    }
}
