﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;

namespace Curse.Friends.Statistics.Models
{
    [DataContract]
    public class FriendsHostStats
    {

        public void ApplyWeightedStats(FriendsHostStats previous, double weight)
        {            

            NewMessages = (int)(NewMessages + previous.NewMessages * weight);
            NewGroupMessages = (int) (NewGroupMessages + previous.NewGroupMessages * weight);
            IdentitiesCreated = (int)(IdentitiesCreated + previous.IdentitiesCreated * weight);
            IdentitiesDeclined = (int)(IdentitiesDeclined + previous.IdentitiesDeclined * weight);
            FriendshipsRemoved = (int)(FriendshipsRemoved + previous.FriendshipsRemoved * weight);
            FriendshipsDeclined = (int)(FriendshipsDeclined + previous.FriendshipsDeclined * weight);
            FriendshipsConfirmed = (int)(FriendshipsConfirmed + previous.FriendshipsConfirmed * weight);
            FriendshipsRequested = (int)(FriendshipsRequested + previous.FriendshipsRequested * weight);
            MessagesRecipients = (int)(MessagesRecipients + previous.MessagesRecipients * weight);

            MutalFriendSuggestionsCreated = (int)(MutalFriendSuggestionsCreated + previous.MutalFriendSuggestionsCreated * weight);
            PlatformFriendSuggestionsCreated = (int)(PlatformFriendSuggestionsCreated + previous.PlatformFriendSuggestionsCreated * weight);
            GameFriendSuggestionsCreated = (int)(GameFriendSuggestionsCreated + previous.GameFriendSuggestionsCreated * weight);
            
            SuggestionsDeclined = (int)(SuggestionsDeclined + previous.SuggestionsDeclined * weight);
            SuggestionsAccepted = (int)(SuggestionsAccepted + previous.SuggestionsAccepted * weight);

            TotalProfilesViewed = (int)(TotalProfilesViewed + previous.TotalProfilesViewed * weight);
            UniqueProfilesViewed = (int)(UniqueProfilesViewed + previous.UniqueProfilesViewed * weight);
            TotalProfileUpdates = (int)(TotalProfileUpdates + previous.TotalProfileUpdates * weight);
            UniqueProfileUpdates = (int)(UniqueProfileUpdates + previous.UniqueProfileUpdates * weight);
            SearchesPerformed = (int)(SearchesPerformed + previous.SearchesPerformed * weight);

            VoiceInvitationsSent = (int)(VoiceInvitationsSent + previous.VoiceInvitationsSent * weight);
            VoiceInvitationsDeclined = (int)(VoiceInvitationsDeclined + previous.VoiceInvitationsDeclined * weight);

            GroupVoiceInvitationsSent = (int)(GroupVoiceInvitationsSent + previous.GroupVoiceInvitationsSent * weight);
            GroupVoiceInvitationsDeclined = (int)(GroupVoiceInvitationsDeclined + previous.GroupVoiceInvitationsDeclined * weight);
            GroupsCreated = (int)(GroupsCreated + previous.GroupsCreated * weight);

            ImagesUploaded = (int)(ImagesUploaded + previous.ImagesUploaded * weight);

            foreach(var kvp in previous.GameNotifications)
            {
                if(!GameNotifications.ContainsKey(kvp.Key))
                {
                    GameNotifications.Add(kvp.Key, 0);
                }                
                GameNotifications[kvp.Key] += (int)(kvp.Value * weight);                
            }
        }

        public FriendsHostStats()
        {
            GameNotifications = new Dictionary<int, int>();
        }

        [DataMember]
        public int MemoryUsageKilobytes
        {
            get;
            set;
        }

        [DataMember]
        public long ReceivedBitsPerSecond
        {
            get;
            set;
        }

        [DataMember]
        public long SentBitsPerSecond
        {
            get;
            set;
        }

        [DataMember]
        public double ProcessorUtilization
        {
            get;
            set;
        }

        [DataMember]
        public double RequestsPerSecond
        {
            get;
            set;
        }

        [DataMember]
        public int ConcurrentConnections
        {
            get;
            set;
        }

        [DataMember]
        public double MessagesPerSecond
        {
            get;
            set;
        }

        [DataMember]
        public double MessagesPerMinute
        {
            get;
            set;
        }

        [DataMember]
        public int NewMessages
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> NewMessagesByPlatform
        {
            get;
            set;
        }

        [DataMember]
        public DateTime StartDate
        {
            get;
            set;
        }

        [DataMember]
        public int PeakConnections
        {
            get;
            set;
        }

        [DataMember]
        public int IdentitiesCreated
        {
            get;
            set;
        }

        [DataMember]
        public int IdentitiesDeclined
        {
            get;
            set;
        }

        [DataMember]
        public int FriendshipsRemoved
        {
            get;
            set;
        }

        [DataMember]
        public int FriendshipsDeclined
        {
            get;
            set;
        }

        [DataMember]
        public int FriendshipsConfirmed
        {
            get;
            set;
        }

        [DataMember]
        public int FriendshipsRequested
        {
            get;
            set;
        }
       
        [DataMember]
        public int MessagesRecipients
        {
            get;
            set;
        }

        [DataMember]
        public int MutalFriendSuggestionsCreated
        {
            get;
            set;
        }

        [DataMember]
        public int PlatformFriendSuggestionsCreated
        {
            get;
            set;
        }

        [DataMember]
        public int GameFriendSuggestionsCreated
        {
            get;
            set;
        }

        [DataMember]
        public long TotalSuggestionsCreated
        {
            get
            {
                return MutalFriendSuggestionsCreated + PlatformFriendSuggestionsCreated + GameFriendSuggestionsCreated;
            }
            set
            {

            }
        }

        [DataMember]
        public int SuggestionsDeclined
        {
            get;
            set;
        }

        [DataMember]
        public int SuggestionsAccepted
        {
            get;
            set;
        }

        [DataMember]
        public int TotalProfilesViewed
        {
            get;
            set;
        }

        [DataMember]
        public int UniqueProfilesViewed
        {
            get;
            set;
        }

        [DataMember]
        public int TotalProfileUpdates
        {
            get;
            set;
        }

        [DataMember]
        public int UniqueProfileUpdates
        {
            get;
            set;
        }

        [DataMember]
        public int SearchesPerformed
        {
            get;
            set;
        }

        [DataMember]
        public long TotalGameNotifications
        {
            get
            {
                return GameNotifications != null ? GameNotifications.Values.Sum() : 0;
            }
            set
            {

            }
        }

        [DataMember]
        public Dictionary<int, int> GameNotifications
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> PlatformIdentitiesDeclinedByType
        {
            get;
            set;
        }


        [DataMember]
        public Dictionary<int, int> PlatformIdentitiesCreatedByType
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> CurrentGames
        {
            get;
            set;
        }

        [DataMember]
        public int VoiceInvitationsSent
        {
            get;
            set;
        }

        [DataMember]
        public int VoiceInvitationsDeclined
        {
            get;
            set;
        }

        [DataMember]
        public IEnumerable<FriendsQueueStats> QueueStats { get; set; }

        [DataMember]
        public Dictionary<int, int> FriendSyncsByResult
        {
            get;
            set;
        }

        [DataMember]
        public int NewGroupMessages
        {
            get;
            set;
        }

        [DataMember]
        public int NewPrivateGroupMessages
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> NewGroupMessagesByPlatform
        {
            get;
            set;
        }

        
        [DataMember]
        public int GroupVoiceInvitationsSent
        {
            get;
            set;
        }

        [DataMember]
        public int GroupVoiceInvitationsDeclined
        {
            get;
            set;
        }


        [DataMember]
        public double GroupMessagesPerMinute
        {
            get;
            set;
        }

        [DataMember]
        public double GroupMessagesPerSecond
        {
            get;
            set;
        }

        [DataMember]
        public double PrivateGroupMessagesPerMinute
        {
            get;
            set;
        }

        [DataMember]
        public double PrivateGroupMessagesPerSecond
        {
            get;
            set;
        }
        [DataMember]
        public Dictionary<int, int> GroupsCreatedByType
        {
            get;
            set;
        }

        [DataMember]
        public int GroupsCreated
        {
            get
            {
                var groupsCreatedByType = GroupsCreatedByType;
                if (groupsCreatedByType == null || groupsCreatedByType.Count == 0)
                {
                    return 0;
                }
                return GroupsCreatedByType.Values.Sum();
            }
            set
            {

            }
        }

        [DataMember]
        public double TotalMessagesPerMinute
        {
            get { return MessagesPerMinute + GroupMessagesPerMinute; }
            set
            {
                
            }
        }

        [DataMember]
        public double TotalMessagesPerSecond
        {
            get { return MessagesPerSecond + GroupMessagesPerSecond; }
            set
            {

            }
        }

        [DataMember]
        public int TotalVoiceInvitationsSent
        {
            get
            {
                return VoiceInvitationsSent + GroupVoiceInvitationsSent;
            }
            set
            {
                
            }
        }

        [DataMember]
        public int TotalInvitationsDeclined
        {
            get
            {
                return VoiceInvitationsDeclined + GroupVoiceInvitationsDeclined;
            }
            set
            {
                
            }
        }

        [DataMember]
        public int ImagesUploaded
        {
            get;
            set;
        }
    }
}
