﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;

namespace Curse.Friends.Statistics.Models
{
    [DataContract]
    public class FriendsPeriodicStats
    {
        [DataMember]
        public DateTime StartDate
        {
            get;
            set;
        }

        [DataMember]
        public int PeakConnections
        {
            get;
            set;
        }

        [DataMember]
        public int IdentitiesCreated
        {
            get;
            set;
        }

        [DataMember]
        public int FriendshipsRemoved
        {
            get;
            set;
        }

        [DataMember]
        public int FriendshipsDeclined
        {
            get;
            set;
        }

        [DataMember]
        public int FriendshipsConfirmed
        {
            get;
            set;
        }

        [DataMember]
        public int FriendshipsRequested
        {
            get;
            set;
        }

        [DataMember]
        public int MessagesSent
        {
            get;
            set;
        }

        [DataMember]
        public int MessagesRecipients
        {
            get;
            set;
        }

        [DataMember]
        public int MutalFriendSuggestionsCreated
        {
            get;
            set;
        }

        [DataMember]
        public int PlatformFriendSuggestionsCreated
        {
            get;
            set;
        }

        [DataMember]
        public int GameFriendSuggestionsCreated
        {
            get;
            set;
        }

        [DataMember]
        public long TotalSuggestionsCreated
        {
            get
            {
                return MutalFriendSuggestionsCreated + PlatformFriendSuggestionsCreated + GameFriendSuggestionsCreated;
            }
            set
            {

            }
        }

        [DataMember]
        public int SuggestionsDeclined
        {
            get;
            set;
        }

        [DataMember]
        public int SuggestionsAccepted
        {
            get;
            set;
        }

        [DataMember]
        public int TotalProfilesViewed
        {
            get;
            set;
        }

        [DataMember]
        public int UniqueProfilesViewed
        {
            get;
            set;
        }

        [DataMember]
        public int TotalProfileUpdates
        {
            get;
            set;
        }

        [DataMember]
        public int UniqueProfileUpdates
        {
            get;
            set;
        }

        [DataMember]
        public int SearchesPerformed
        {
            get;
            set;
        }

        [DataMember]
        public long TotalGameNotifications
        {
            get
            {
                return GameNotifications != null ? GameNotifications.Values.Sum() : 0;
            }
            set
            {

            }
        }

        [DataMember]
        public Dictionary<int, int> GameNotifications
        {
            get;
            set;
        }
 
    }
}
