﻿using Curse.Friends.Enums;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;

namespace Curse.Friends.Statistics.Models
{
    [DataContract]
    public class FriendsRegionStats
    {
        public FriendsRegionStats()
        {
            UserCountByCurrentGame = new Dictionary<int, long>();
            UserCountByStatus = new Dictionary<UserConnectionStatus, long>();
        }

        public int RegionID { get; set; }

        [DataMember]
        public DateTime StartDate
        {
            get;
            set;
        }

        [DataMember]
        public long TotalUsers
        {
            get;
            set;
        }

        [DataMember]
        public long TotalFriendships
        {
            get;
            set;
        }
        
        [DataMember]
        public int MaxFriendsPerUser
        {
            get;
            set;
        }

        [DataMember]
        public double AverageFriendsPerUser
        {
            get;
            set;
        }

        [DataMember]
        public double AverageFriendsPerEngagedUser
        {
            get;
            set;
        }

        [DataMember]
        public int UsersWithFriends
        {
            get;
            set;
        }

        [DataMember]
        public int MedianFriendsPerUser
        {
            get;
            set;
        }

        [DataMember]
        public long TotalFavorites
        {
            get;
            set;
        }

        [DataMember]
        public long TotalPendingFriendRequests
        {
            get;
            set;
        }

        [DataMember]
        public long TotalOutOfRegionFriends
        {
            get;
            set;
        }

        [DataMember]
        public long OnlineUserCount
        {
            get
            {
                return UserCountByStatus != null ? UserCountByStatus.Where(p => p.Key != UserConnectionStatus.Offline).Sum(p => p.Value) : 0;
            }
            set
            {

            }
        }

        [DataMember]
        public long ActiveUserCount
        {
            get
            {
                return UserCountByStatus != null ? UserCountByStatus.Where(p => p.Key != UserConnectionStatus.Offline && p.Key != UserConnectionStatus.Idle).Sum(p => p.Value) : 0;
            }
            set
            {

            }
        }

        [DataMember]
        public long ActivelyGaming
        {
            get
            {
                return UserCountByCurrentGame != null ? UserCountByCurrentGame.Values.Sum() : 0;
            }
            set
            {

            }
        }


        [DataMember]
        public Dictionary<UserConnectionStatus, long> UserCountByStatus
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, long> UserCountByCurrentGame
        {
            get;
            set;
        }               

        [DataMember]
        public Dictionary<int, long> IdentitiesByGame
        {
            get;
            set;
        }

        [DataMember]
        public long TotalGameIdentities
        {
            get
            {
                return IdentitiesByGame == null ? 0 : IdentitiesByGame.Values.Sum();
            }
            set
            {

            }
        }

        [DataMember]
        public Dictionary<FriendPlatform, long> IdentitiesByPlatform
        {
            get;
            set;
        }

        [DataMember]
        public long TotalPlatformIdentities
        {
            get
            {
                return IdentitiesByPlatform == null ? 0 : IdentitiesByPlatform.Values.Sum();
            }
            set
            {

            }
        }

        [DataMember]
        public int UsersWithProfiles
        {
            get;
            set;
        }


        [DataMember]
        public int TotalFriendSuggestions
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> FriendSuggestionsByStatus
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> FriendSuggestionsByType
        {
            get;
            set;
        }


        [DataMember]
        public Dictionary<int, int> FriendSuggestionsByGame
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> FriendSuggestionsByPlatform
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> FriendSuggestionsAcceptedByGame
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> FriendSuggestionsDeclinedByGame
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> FriendSuggestionsPendingByGame
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> FriendSuggestionsAcceptedByPlatform
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> FriendSuggestionsDeclinedByPlatform
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> FriendSuggestionsPendingByPlatform
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> TotalGroupsByType
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> TotalGroupsByStatus
        {
            get;
            set;
        }

        [DataMember]
        public Dictionary<int, int> GroupsCountBySize
        {
            get;
            set;
        }

        [DataMember]
        public int TotalGroups
        {
            get; set;
        }

        [DataMember]
        public double AverageGroupSize
        {
            get;
            set;
        }

        [DataMember]
        public double EngagedAverageGroupSize
        {
            get;
            set;
        }

        [DataMember]
        public int MaxGroupSize
        {
            get;
            set;
        }

        [DataMember]
        public int TotalGroupMembers
        {
            get;
            set;
        }

        [DataMember]
        public int GroupsWithPushToTalk
        {
            get;
            set;
        }


 
    }
}
