﻿using System;
using System.Collections.Generic;
using System.ComponentModel;

namespace Curse.Friends.Statistics
{
    public class EnumeratedStatCounter<T>
    {        
        private readonly Dictionary<T, SimpleStatCounter> _counters;

        public EnumeratedStatCounter()
        {
            if (!typeof (T).IsEnum)
            {
                throw new InvalidEnumArgumentException("Type should be enum");
            }
            
            var counters = new Dictionary<T, SimpleStatCounter>();
            
            var enumValues = Enum.GetValues(typeof (T));

            foreach (var val in enumValues)
            {
                counters[(T) val] = new SimpleStatCounter();
            }

            _counters = counters;
        }

        public Dictionary<T, int> Values
        {
            get
            {
                var dict = new Dictionary<T, int>();
                foreach (var kvp in _counters)
                {
                    dict[kvp.Key] = kvp.Value.Counter;
                }

                return dict;
            }
        }

        public void Track(T identifer)
        {
            SimpleStatCounter counter;
            if (!_counters.TryGetValue(identifer, out counter))
            {
                return;
            }

            counter.Track();
        }

        public void Decrement(T identifer)
        {
            SimpleStatCounter counter;
            if (!_counters.TryGetValue(identifer, out counter))
            {
                return;
            }

            counter.Decrement();
        }
    }
}
