﻿using System;
using System.Collections.Generic;
using Curse.Friends.Statistics.Models;

namespace Curse.Friends.Statistics
{
    public class FriendsStats
    {
        public DateTime StartDate
        {
            get;
            private set;
        }

        public FriendsStats(DateTime startDate)
        {
            StartDate = startDate;
        }

        public FriendsStats(DateTime startDate, FriendsStats oldStats)
            : this(startDate)
        {
            CurrentConnections = oldStats.CurrentConnections;
            CurrentGames = oldStats.CurrentGames;
            PeakConnections.Track(oldStats.CurrentConnections.Amount);
        }

        public SimplePeriodicUserStat<int> MessagesSent = new SimplePeriodicUserStat<int>();
        public GroupedStatCounter MessagesSentByPlatform = new GroupedStatCounter();
        public SimplePeriodicUserStat<Guid> GroupMessagesSent = new SimplePeriodicUserStat<Guid>();
        public SimplePeriodicUserStat<string> PrivateGroupMessagesSent = new SimplePeriodicUserStat<string>();
        public GroupedStatCounter GroupMessagesSentByPlatform = new GroupedStatCounter();

        public SimpleUserStat IdentitiesCreated = new SimpleUserStat();
        public GroupedStatCounter PlatformIdentitiesCreatedByType = new GroupedStatCounter();

        public SimpleUserStat IdentitiesDeclined = new SimpleUserStat();
        public GroupedStatCounter PlatformIdentitiesDeclinedByType = new GroupedStatCounter();

        public GroupedStatCounter FriendSyncsByResult = new GroupedStatCounter();

        public SimpleStatCounter FriendRequestsSent = new SimpleStatCounter();
        public SimpleStatCounter FriendRequestsConfirmed = new SimpleStatCounter();
        public SimpleStatCounter FriendRequestsDeclined = new SimpleStatCounter();
        public SimpleStatCounter FriendRequestsRemoved = new SimpleStatCounter();
        public SimpleStatCounter PlatformSuggestions = new SimpleStatCounter();
        public SimpleStatCounter GameSuggestions = new SimpleStatCounter();
        public SimpleStatCounter SuggestionsDeclined = new SimpleStatCounter();
        public SimpleStatCounter SuggestionsAccepted = new SimpleStatCounter();
        public SimpleStatCounter MutualFriendSuggestions = new SimpleStatCounter();
        public SimpleUserStat ProfilesViewed = new SimpleUserStat();
        public SimpleUserStat ProfilesUpdated = new SimpleUserStat();
        public SimpleStatCounter SearchesPerformed = new SimpleStatCounter();
        public GroupedStatCounter GameNotifications = new GroupedStatCounter();
        public GroupedStatCounter CurrentGames = new GroupedStatCounter();
        public SimpleStatCounter VoiceInvitationsSent = new SimpleStatCounter();
        public SimpleStatCounter GroupVoiceInvitationsSent = new SimpleStatCounter();
        public SimpleStatCounter VoiceInvitationsDeclined = new SimpleStatCounter();
        public SimpleStatCounter GroupVoiceInvitationsDeclined = new SimpleStatCounter();
        public GroupedStatCounter GroupsCreatedByType = new GroupedStatCounter();

        internal SimpleUserStat NewConnections = new SimpleUserStat();
        internal SimpleMaxStat PeakConnections = new SimpleMaxStat();
        internal SimpleStat CurrentConnections = new SimpleStat();

        public IEnumerable<FriendsQueueStats> QueueStats { get; set; }

        public SimpleStatCounter ImagesUploaded = new SimpleStatCounter();

        public void TrackUserConnected(int userID, int numConnections)
        {
            NewConnections.Track(userID);
            PeakConnections.Track(numConnections);
            CurrentConnections.Track(numConnections);
        }

        public void TrackUserDisconnected(int numConnections)
        {
            CurrentConnections.Track(numConnections);
        }
    }
}
