﻿using System.Collections.Generic;

namespace Curse.Friends.Statistics
{
    public class GroupedStatCounter
    {
        private readonly object _syncRoot = new object();
        private readonly Dictionary<int, SimpleStatCounter> _counters = new Dictionary<int, SimpleStatCounter>();

        public Dictionary<int, int> Values
        {
            get
            {
                var dict = new Dictionary<int, int>();

                lock (_syncRoot)
                {
                    foreach (var kvp in _counters)
                    {
                        dict[kvp.Key] = kvp.Value.Counter;
                    }
                }

                return dict;
                
            }
            
        }

        public void Track(int identifer)
        {
            lock (_syncRoot)
            {
                SimpleStatCounter counter;

                if (!_counters.TryGetValue(identifer, out counter))
                {
                    counter = new SimpleStatCounter();
                    _counters.Add(identifer, counter);
                }
                
                counter.Track();
            }
            
        }

        public void Decrement(int identifer)
        {
            lock (_syncRoot)
            {
                SimpleStatCounter counter;

                if (!_counters.TryGetValue(identifer, out counter))
                {
                    counter = new SimpleStatCounter();
                    _counters.Add(identifer, counter);
                }

                counter.Decrement();
            }            
        }
    }
}
