﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Threading;

namespace Curse.Friends.Statistics
{
    public class SimplePeriodicUserStat<T1>
    {
                
        private int _currentSecond;
        private int _previousSecondlyCounter = 0;
        private int _currentSecondlyCounter = 0;

        private int _currentMinute;
        private int _previousMinutelyCounter = 0;
        private int _currentMinutelyCounter = 0;

        private int _lifetimeCounter = 0;

        private readonly object _syncRoot = new object();
        private readonly Dictionary<T1, byte> _users;
        
        public SimplePeriodicUserStat()
        {
            _users = new Dictionary<T1, byte>();
            _timer = new System.Timers.Timer(1000);
            _timer.Elapsed += _timer_Elapsed;
            _timer.Start();
        }
        
        public int LifetimeCounter
        {
            get
            {
                return _lifetimeCounter;
            }
        }

        public int SecondlyCounter
        {
            get
            {
                return _previousSecondlyCounter + _currentSecondlyCounter;
            }
        }

        public int MinutelyCounter
        {
            get
            {
                return _previousMinutelyCounter + _currentMinutelyCounter;
            }
        }

        public int UniqueCounter
        {
            get
            {
                lock (_syncRoot)
                {
                    return _users.Count;    
                }                
            }
        }   

        public double ElapsedSeconds
        {
            get
            {                           
                return 2;
            }
        }

        public double ElapsedMinutes
        {
            get
            {
                return 1 + (DateTime.UtcNow.Second / 60);
            }
        }

        private readonly System.Timers.Timer _timer;
       
        void _timer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            _timer.Stop();
            Tend();
            _timer.Start();
        }

        private void Tend()
        {
            if (DateTime.UtcNow.Second != _currentSecond)
            {
                _currentSecond = DateTime.UtcNow.Second;
                _previousSecondlyCounter = _currentSecondlyCounter;
                Interlocked.Exchange(ref _currentSecondlyCounter, 0);
            }

            if (DateTime.UtcNow.Minute != _currentMinute)
            {
                _currentMinute = DateTime.UtcNow.Minute;
                _previousMinutelyCounter = _currentMinutelyCounter;
                Interlocked.Exchange(ref _currentMinutelyCounter, 0);
            }
        }

        public void Track(T1 userID)
        {
            lock (_syncRoot)
            {
                if (!_users.ContainsKey(userID))
                {
                    _users.Add(userID, 1);        
                }                
            }
            
            Interlocked.Increment(ref _currentMinutelyCounter);
            Interlocked.Increment(ref _currentSecondlyCounter);
            Interlocked.Increment(ref _lifetimeCounter);
        }
    }
}
