﻿using System.Threading;

namespace Curse.Friends.Statistics
{
    public class SimpleStatCounter
    {
        private int _counter = 0;        
        
        public int Counter
        {
            get
            {
                return _counter;
            }
        }              

        public void Track()
        {            
            Interlocked.Increment(ref _counter);
        }

        public void Decrement()
        {
            Interlocked.Decrement(ref _counter);
        }
    }
}
