﻿using System.Collections.Generic;
using System.Threading;

namespace Curse.Friends.Statistics
{
    public class SimpleUserStat
    {
        private int _counter = 0;
        private readonly object _syncRoot = new object();
        private readonly Dictionary<int, byte> _users = new Dictionary<int, byte>();

        public int Counter
        {
            get
            {
                return _counter;
            }
        }

        public int UniqueCounter
        {
            get
            {
                lock (_syncRoot)
                {
                    return _users.Count;
                }
            }
        }   

        public void Track(int userID)
        {
            lock (_syncRoot)
            {
                if (!_users.ContainsKey(userID))
                {
                    _users.Add(userID, 1);
                }                    
            }            
            Interlocked.Increment(ref _counter);
        }
    }
}
