﻿using System.Collections.Generic;
using System.Xml.Serialization;
using Curse.Friends.Configuration;

namespace Curse.Friends.StatsWebService.Configuration
{

    [XmlRoot("Service")]
    public class StatsWebServiceConfiguration
    {
        private static StatsWebServiceConfiguration _current;
        public static StatsWebServiceConfiguration Current
        {
            get
            {
                if (_current == null)
                {
                    _current = ConfigurationHelper.LoadConfiguration<StatsWebServiceConfiguration>(FriendsServiceConfiguration.Mode, "StatsWebServiceConfiguration");
                }

                return _current;
            }
        }

        [XmlElement("DatabaseConnectionString")]
        public string DatabaseConnectionString { get; set; }

        [XmlArray]
        [XmlArrayItem("User")]
        public HashSet<int> AuthorizedUsers { get; set; }
      
    }
}